﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using Advent.aiDevices;

namespace Advent.Controls
{
    public partial class MFGen : UserControl
    {

        private MFGenerator MF = null;

        public MFGen()
        {
            InitializeComponent();

            TimeInterval SITOnTime1 = TimeInterval.InMilliseconds(330);
            TimeInterval SITOnTime2 = TimeInterval.InMilliseconds(274);
            TimeInterval SITOnTime3 = TimeInterval.InMilliseconds(200);


            cbo_Signal.Items.Clear();
            cbo_Signal.Items.Add( MultiToneSequence.Create("Special Information Tone (No Circuit Found)",
                                                            Cadence.AdjacentTiming(SITOnTime1, SITOnTime1, SITOnTime1),
                                                            new Tone(SignalLevel.IndBV(-10), Frequency.InHz(985)),
                                                            new Tone(SignalLevel.IndBV(-10), Frequency.InHz(1428)),
                                                            new Tone(SignalLevel.IndBV(-10), Frequency.InHz(1776))));


            cbo_Signal.Items.Add(MultiToneSequence.Create("Special Information Tone (Reorder)",
                                                            Cadence.AdjacentTiming(SITOnTime2, SITOnTime2, SITOnTime2),
                                                            new Tone(SignalLevel.IndBV(-10), Frequency.InHz(913)),
                                                            new Tone(SignalLevel.IndBV(-10), Frequency.InHz(1428)),
                                                            new Tone(SignalLevel.IndBV(-10), Frequency.InHz(1776))));


            cbo_Signal.Items.Add(MultiToneSequence.Create("Netherlands - Call Intrusion",
                                                            Cadence.AdjacentTiming(SITOnTime3, SITOnTime3, SITOnTime3, SITOnTime3),
                                                            new Tone(SignalLevel.IndBV(-10), Frequency.InHz(1250)),
                                                            new Tone(SignalLevel.IndBV(-10), Frequency.InHz(900)),
                                                            new Tone(SignalLevel.IndBV(-10), Frequency.InHz(800)),
                                                            new Tone(SignalLevel.IndBV(-10), Frequency.InHz(1000))));

            // Irish payphone consists of (1750 + 1110) followed by (750 + 1450)
            cbo_Signal.Items.Add(new MultiToneSequence("Irish - Payphone Recognition",
                                                            new Cadence(SITOnTime3, SITOnTime3, SITOnTime3),
                                                            new MultiToneSignal(SignalLevel.IndBV(-10), Frequency.InHz(1100), Frequency.InHz(1750)),
                                                            new MultiToneSignal(SignalLevel.IndBV(-10), Frequency.InHz(750),Frequency.InHz(1450))));


            TimeInterval T = TimeInterval.InMilliseconds(50);
            MultiToneSignal Digit1 = new MultiToneSignal(SignalLevel.IndBV(-10), Frequency.InHz(440), Frequency.InHz(523));
            MultiToneSignal Digit2 = new MultiToneSignal(SignalLevel.IndBV(-10), Frequency.InHz(466), Frequency.InHz(554));
            MultiToneSignal Digit3 = new MultiToneSignal(SignalLevel.IndBV(-10), Frequency.InHz(523), Frequency.InHz(587));

            cbo_Signal.Items.Add(new MultiToneSequence("Ascending and Descending tones",
                                                            Cadence.AdjacentTiming(SITOnTime3, SITOnTime3, SITOnTime3, SITOnTime3, SITOnTime3),
                                                            Digit1,Digit2,Digit3,Digit2,Digit1));


            /******************************************************************************************************************
             * OK morse code is not part of telephony but this example shows the complexity in signal timing which can be 
             * specified
             * ***************************************************************************************************************/

            TimeInterval Long = TimeInterval.InMilliseconds(150);
            TimeInterval Short = TimeInterval.InMilliseconds(50);
            Tone Morse = new Tone(SignalLevel.InVrms(0.25), Frequency.InHz(1200));

            cbo_Signal.Items.Add(MultiToneSequence.Create("Morse code SOS",
                                                            new Cadence(Short,Short,Short,Short,Short,Short,
                                                                        Long,Long,Long,Long,Long,Long, 
                                                                        Short,Short,Short,Short,Short,Short),
                                                                        Morse, Morse, Morse, Morse, Morse, Morse, Morse, Morse, Morse));


            cbo_Signal.Items.Add(new CAS(SignalLevel.IndBV(-5), TimeInterval.InMilliseconds(80)));

            cbo_Signal.Items.Add(new DTMFDigit('3', SignalLevel.IndBV(-10), TimeInterval.InMilliseconds(250)));


            /******************************************************************************************************************
             * Here we create DTMF dialling with equal levels, twist, frequency error, and timing
             * ***************************************************************************************************************/
            cbo_Signal.Items.Add(DTMF.CreateDTMFDialing("6049444298",
                                                                SignalLevel.IndBV(-8),
                                                                UnitlessQuantity.IndB(3), 
                                                                0.1, 
                                                                TimeInterval.InMilliseconds(100), 
                                                                TimeInterval.InMilliseconds(200)));



            /******************************************************************************************************************
             * Here we create DTMF dialling with completely arbitrary DTMF specifications
             * ***************************************************************************************************************/

            // Specify our digits completely independently
            IFiniteSignal[] Digits  = new IFiniteSignal[]{ new DTMFDigit('1',0.25,SignalLevel.IndBV(-15), UnitlessQuantity.IndB(-1),TimeInterval.InMilliseconds(100)) ,
                                                           new DTMFDigit('2',-0.5,SignalLevel.IndBV(-5), UnitlessQuantity.IndB(+2),TimeInterval.InMilliseconds(150)), 
                                                           new DTMFDigit('3',0,SignalLevel.IndBV(0), UnitlessQuantity.IndB(0),TimeInterval.InMilliseconds(200))};
            
            // specify the inter-digit timing
            TimeInterval[] InterDigit = new TimeInterval[]{TimeInterval.InMilliseconds(250), TimeInterval.InMilliseconds(300)};

            // Now create the multi-tone sequence
            cbo_Signal.Items.Add(MultiToneSequence.Create("DTMF '123' with arbitrary levels/frequencies/timing",
                                                            Digits,InterDigit));

            cbo_Signal.SelectedIndex = 0;

            this.EnabledChanged += new EventHandler(MFGenCtrl_EnabledChanged);

        }

        void MFGenCtrl_EnabledChanged(object sender, EventArgs e)
        {
            timer_Update.Enabled = this.Enabled;
        }

        public void SetGenerator(MFGenerator MF)
        {
            this.MF = MF;
        }

        private void btn_Generate_Click(object sender, EventArgs e)
        {
            try
            {
                MF.Generate((ISignal)cbo_Signal.SelectedItem);

            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
            }
        }

        private void timer_Update_Tick(object sender, EventArgs e)
        {
            try
            {
                if (MF.IsActive)
                {
                    gb_MFGenerator.Text = "MF Generator (Active)";
                }
                else
                {
                    gb_MFGenerator.Text = "MF Generator";
                }
            }
            catch { }
        }

 




    }
}
